
from gurobipy import *

# Create a new model
m = Model("Movie_Theatre_Profit")

# Define variables
M = m.addVar(vtype=GRB.INTEGER, name="Moving_Seats")
R = m.addVar(vtype=GRB.INTEGER, name="Regular_Seats")

# Set the objective function: Maximize profit
m.setObjective(15*M + 10*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(M + R <= 100, "Total_seats")
m.addConstr(M >= 15, "Moving_seats_minimum")
m.addConstr(R >= 3*M, "Regular_vs_Moving_seats")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Moving Seats:", M.x)
    print("Regular Seats:", R.x)
    print("Maximum Profit:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

