
import gurobi

def solve_movie_theatre_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=15, name="moving_seats")  # At least 15 moving seats
    y = model.addVar(name="regular_seats")

    # Objective function: Maximize profit
    model.setObjective(15 * x + 10 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 100, name="total_capacity")
    model.addConstr(y >= 3 * x, name="preference_constraint")
    model.addConstr(y >= 0, name="non_negativity_y")  # Explicitly adding non-negativity for y

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal moving seats: {x.varValue}")
        print(f"Optimal regular seats: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_movie_theatre_problem()
