
from gurobipy import *

# Create a model
m = Model("Ad_Placement")

# Define variables
A = m.addVar(name='Airports', vtype=GRB.INTEGER, lb=0)
M = m.addVar(name='Malls', vtype=GRB.INTEGER, lb=0)
T = m.addVar(name='Movie_Theatres', vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(100000*A + 40000*M + 10000*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(A <= 5, name='Airport Limit')
m.addConstr(10000*A + 3000*M + 2000*T <= 100000, name='Budget Constraint')
m.addConstr(T <= (A + M + T)/2, name='Movie Theatre Proportion')
m.addConstr(M >= 0.3*(A + M + T), name='Mall Proportion')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print('Airports:', A.x)
    print('Malls:', M.x)
    print('Movie Theatres:', T.x)
else:
    print('No optimal solution found')
