
import gurobipy as gp

# Create a new model
m = gp.Model("Ad_Placement")

# Decision variables
A = m.addVar(lb=0, ub=5, vtype=gp.GRB.INTEGER, name="Airports")
M = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Malls")
T = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Movie_Theatres")

# Objective: Maximize viewership
m.setObjective(100000*A + 40000*M + 10000*T, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(A <= 5, name="Airport_Limit")
m.addConstr(T <= A + M, name="Movie_Theatre_Limit")
m.addConstr(M >= 0.3*(A + M + T), name="Mall_Minimum")
m.addConstr(10000*A + 3000*M + 2000*T <= 100000, name="Budget")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Airports: {A.varValue}")
    print(f"Malls: {M.varValue}")
    print(f"Movie Theatres: {T.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found")
