
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Matter_Auto_Advertising")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sports_ads")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tv_show_ads")

# Set objective function
m.setObjective(90000 * x + 20000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * x + 12 * y >= 40, "baby_boomers")
m.addConstr(18 * x + 5 * y >= 25, "millennials")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Number of Sports Ads: {x.x}")
    print(f"Number of TV Show Ads: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

