
from gurobipy import *

# Create a new model
m = Model("Matter_Auto_Advertising")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sports_ads", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="tv_show_ads", lb=0)

# Set the objective function to minimize cost
m.setObjective(90000*x1 + 20000*x2, GRB.MINIMIZE)

# Add constraints for reaching baby boomers and millennials
m.addConstr(4*x1 + 12*x2 >= 40, name="baby_boomers")
m.addConstr(18*x1 + 5*x2 >= 25, name="millennials")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Purchase {x1.x} sports ads")
    print(f"Purchase {x2.x} TV show ads")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
