
import gurobi

def solve_advertising_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(name="sports_ads", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="tv_show_ads", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize cost
    model.setObjective(90000*x1 + 20000*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x1 + 12*x2 >= 40000000, name="baby_boomers_constraint")
    model.addConstr(18*x1 + 5*x2 >= 25000000, name="millennials_constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Sports ads: {x1.varValue}")
        print(f"TV show ads: {x2.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_advertising_problem()
