
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Bouquets")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daisies") # Number of daisy bouquets
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lilies")  # Number of lily bouquets

# Set objective function
m.setObjective(5*x + 4*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + y <= 1000, "clipping_time")
m.addConstr(2*x + 3*y <= 650, "packaging_time")
m.addConstr(x >= 25, "min_daisies")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Daisy Bouquets: {x.x:.2f}")
    print(f"Number of Lily Bouquets: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

