
from gurobipy import *

# Create a model
m = Model("Gardener_Profit_Optimization")

# Decision variables
x_d = m.addVar(lb=25, vtype=GRB.CONTINUOUS, name="daisies")
x_l = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lilies")

# Objective function: Maximize profit
m.setObjective(5*x_d + 4*x_l, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x_d + x_l <= 1000, "clipping_time")
m.addConstr(2*x_d + 3*x_l <= 650, "packaging_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of daisies: {x_d.x}")
    print(f"Number of lilies: {x_l.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found.")
