
import gurobi

def solve_garden_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=25, name="daisies")  # At least 25 bouquets of daisies
    y = model.addVar(lb=0, name="lilies")   # No limit on bouquets of lilies

    # Objective function: Maximize profit
    model.setObjective(5 * x + 4 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x + y <= 1000, name="clipping_time")
    model.addConstr(2 * x + 3 * y <= 650, name="packaging_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal profit: ", model.objVal)
        print("Bouquets of daisies: ", x.varValue)
        print("Bouquets of lilies: ", y.varValue)
    else:
        print("The model is infeasible")

solve_garden_problem()
