
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Electronics_Repair")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="phones")  # Number of phones
y = model.addVar(vtype=GRB.INTEGER, name="laptops") # Number of laptops

# Set objective function
model.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 30*y <= 6000, "inspection_constraint")
model.addConstr(30*x + 50*y <= 7000, "fixing_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of phones to repair: {x.x}")
    print(f"Number of laptops to repair: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

