
from gurobipy import *

# Create a new model
model = Model("Electronics_Repair")

# Define the decision variables
P = model.addVar(lb=0, vtype=GRB.INTEGER, name="Phones")
L = model.addVar(lb=0, vtype=GRB.INTEGER, name="Laptops")

# Define the objective function: Maximize profit
model.setObjective(50*P + 60*L, GRB.MAXIMIZE)

# Add constraints
# Inspection time constraint
model.addConstr(20*P + 30*L <= 6000, "Inspection_Time")
# Fixing time constraint
model.addConstr(30*P + 50*L <= 7000, "Fixing_Time")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: Repair {P.x} phones and {L.x} laptops.")
    print(f"Maximum profit: ${model.ObjVal}")
else:
    print("No optimal solution found.")
