
import gurobipy as gp

# Create a new model
model = gp.Model("Electronics_Repair_Shop")

# Define variables
P = model.addVar(name="phones", lb=0, vtype=gp.GRB.INTEGER)
L = model.addVar(name="laptops", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(50 * P + 60 * L, sense=gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20 * P + 30 * L <= 6000, name="inspection_time")
model.addConstr(30 * P + 50 * L <= 7000, name="fixing_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Profit: ${model.objVal}")
    print(f"Phones to repair: {P.varValue}")
    print(f"Laptops to repair: {L.varValue}")
else:
    print("No optimal solution found.")
