
from gurobipy import *

# Create a new model
m = Model("FaceWashProduction")

# Define the decision variables
L = m.addVar(vtype=GRB.CONTINUOUS, name="LowQuality")
M = m.addVar(vtype=GRB.CONTINUOUS, name="MediumQuality")
H = m.addVar(vtype=GRB.CONTINUOUS, name="HighQuality")

# Set the objective function
m.setObjective(3*L + 7*M + 9*H, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L + 3*M + 4*H <= 100, "RareIngredients")
m.addConstr(4*L + 2*M + H <= 200, "Water")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Low Quality: {L.x}")
    print(f"Medium Quality: {M.x}")
    print(f"High Quality: {H.x}")
else:
    print("No optimal solution found")
