
import gurobi

def solve_face_wash_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    L = model.addVar(lb=0, name="Low_Quality")
    M = model.addVar(lb=0, name="Medium_Quality")
    H = model.addVar(lb=0, name="High_Quality")

    # Objective function: Maximize profits
    model.setObjective(3*L + 7*M + 9*H, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(L + 3*M + 4*H <= 100, name="Rare_Ingredients")
    model.addConstr(4*L + 2*M + H <= 200, name="Water")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Low Quality Face Wash: {L.varValue}")
        print(f"Medium Quality Face Wash: {M.varValue}")
        print(f"High Quality Face Wash: {H.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_face_wash_problem()
