
import gurobipy as gp

# Create a new model
model = gp.Model("Meal Optimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vegetarian_meals")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="meat_meals")

# Set objective function
model.setObjective(4*x + 6*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(10*x + 30*y >= 100, "protein_req")
model.addConstr(20*x + 15*y >= 150, "carb_req")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Vegetarian Meals: {x.x}")
    print(f"Number of Meat Meals: {y.x}")
    print(f"Minimum Cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

