
from gurobipy import *

# Create a model
m = Model("Meal_Optimization")

# Define decision variables
V = m.addVar(vtype=GRB.CONTINUOUS, name="Vegetarian_Meals")
M = m.addVar(vtype=GRB.CONTINUOUS, name="Meat_Meals")

# Objective function: Minimize total cost
m.setObjective(4*V + 6*M, GRB.MINIMIZE)

# Constraints
m.addConstr(10*V + 30*M >= 100, "Protein_Requirement")
m.addConstr(20*V + 15*M >= 150, "Carb_Requirement")

# Non-negativity constraints (not strictly necessary since Gurobi defaults to non-negative for continuous variables)
# m.addConstr(V >= 0, "Non_Negative_Vegetarian")
# m.addConstr(M >= 0, "Non_Negative_Meat")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vegetarian Meals: {V.x}")
    print(f"Meat Meals: {M.x}")
    print(f"Total Cost: ${4*V.x + 6*M.x:.2f}")
else:
    print("No optimal solution found")
