
import gurobi

def solve_meal_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="vegetarian_meals", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of vegetarian meals
    y = model.addVar(name="meat_meals", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of meat meals

    # Objective function: Minimize cost
    model.setObjective(4 * x + 6 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * x + 30 * y >= 100, name="protein_requirement")  # Protein requirement
    model.addConstr(20 * x + 15 * y >= 150, name="carbs_requirement")  # Carbs requirement

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has no optimal solution.")

solve_meal_problem()
