
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cacaotier")

# Create decision variables
t = m.addVar(vtype=GRB.INTEGER, name="truffles")
b = m.addVar(vtype=GRB.INTEGER, name="bars")

# Set objective function
m.setObjective(7*t + 3*b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(700*t + 300*b <= 30000, "cocoa_limit")
m.addConstr(b >= 2*t, "demand")
m.addConstr(t >= 10, "min_truffles")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of truffles: {t.x}")
    print(f"Number of bars: {b.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

