
from gurobipy import *

# Create a new model
m = Model("Cacaotier_Profit_Optimization")

# Decision variables
x_t = m.addVar(vtype=GRB.INTEGER, name="gourmet_truffles", lb=0)
x_c = m.addVar(vtype=GRB.INTEGER, name="chocolate_bars", lb=0)

# Objective function: Maximize profit
m.setObjective(7*x_t + 3*x_c, GRB.MAXIMIZE)

# Constraints
m.addConstr(700*x_t + 300*x_c <= 30000, "cocoa_availability")
m.addConstr(x_t >= 10, "minimum_gourmet_truffles")
m.addConstr(x_c >= 2*x_t, "consumer_research")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Gourmet Truffles: {x_t.x}")
    print(f"Chocolate Bars: {x_c.x}")
    print(f"Maximum Profit: ${7*x_t.x + 3*x_c.x}")
else:
    print("No optimal solution found")
