
import gurobi

def solve_cacaotier_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=10, name="gourmet_truffles")  # At least 10 truffles
    y = model.addVar(name="chocolate_bars")

    # Objective function: Maximize profit
    model.setObjective(7 * x + 3 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(700 * x + 300 * y <= 30000, name="cocoa_availability")
    model.addConstr(y >= 2 * x, name="demand_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Gourmet Truffles: {x.varValue}")
        print(f"Chocolate Bars: {y.varValue}")
        print(f"Maximum Profit: ${7 * x.varValue + 3 * y.varValue}")
    else:
        print("No optimal solution found.")

solve_cacaotier_problem()
