
import gurobipy as gp

# Create a new model
model = gp.Model("Pie Production")

# Create decision variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # Regular pies
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # Premium pies

# Set objective function
model.setObjective(8*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 50, "Demand_Regular")
model.addConstr(x2 <= 30, "Demand_Premium")
model.addConstr(x1 + x2 <= 60, "Total_Production")
model.addConstr(x1 >= 0, "NonNeg_x1")  # Though CONTINUOUS implies this
model.addConstr(x2 >= 0, "NonNeg_x2")  # Though CONTINUOUS implies this


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Number of regular pies (x1): {x1.x}")
    print(f"Number of premium pies (x2): {x2.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

