
from gurobipy import *

# Create a new model
m = Model("Pie_Shop_Profit")

# Define variables
x1 = m.addVar(lb=0, name="regular_pies")
x2 = m.addVar(lb=0, name="premium_pies")

# Set objective function: Maximize profit
m.setObjective(8*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 50, "demand_regular")
m.addConstr(x2 <= 30, "demand_premium")
m.addConstr(x1 + x2 <= 60, "total_pies")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Pies: {x1.x}")
    print(f"Premium Pies: {x2.x}")
    print(f"Max Profit: ${8*x1.x + 10*x2.x:.2f}")
else:
    print("No optimal solution found")
