
import gurobi

def solve_pie_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="regular_pies")
    x2 = model.addVar(lb=0, name="premium_pies")

    # Objective function: Maximize profit
    model.setObjective(8 * x1 + 10 * x2, gurobi.GRB.MAXIMIZE)

    # Demand constraints
    model.addConstr(x1 <= 50, name="regular_demand_constraint")
    model.addConstr(x2 <= 30, name="premium_demand_constraint")

    # Total production constraint
    model.addConstr(x1 + x2 <= 60, name="total_production_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of regular pies to produce: {x1.x}")
        print(f"Number of premium pies to produce: {x2.x}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_pie_shop_problem()
