
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("KeyboardProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="x") # A400 keyboards
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="y") # P500 keyboards


# Set objective function
model.setObjective(35*x + 80*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 9*y <= 45, "LaborConstraint")
model.addConstr(x >= 3*y, "DemandConstraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Number of A400 keyboards: {x.x}")
    print(f"Number of P500 keyboards: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

