
from gurobipy import *

# Create a model
m = Model("Curious_Electronics")

# Define the decision variables
xA = m.addVar(vtype=GRB.CONTINUOUS, name="xA", lb=0)  # Number of A400 keyboards
xP = m.addVar(vtype=GRB.CONTINUOUS, name="xP", lb=0)  # Number of P500 keyboards

# Define the objective function: Maximize profit
m.setObjective(35*xA + 80*xP, GRB.MAXIMIZE)

# Add constraints
# Labour hours constraint
m.addConstr(5*xA + 9*xP <= 45, name="labour_hours")

# Demand forecast constraint
m.addConstr(xA >= 3*xP, name="demand_forecast")

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Produce {xA.x} A400 keyboards and {xP.x} P500 keyboards.")
    print(f"Maximum profit: ${35*xA.x + 80*xP.x:.2f}")
else:
    print("No optimal solution found. The model is infeasible or unbounded.")

