
import gurobipy as gp

def solve_production_problem():
    # Create a new model
    model = gp.Model("production_problem")

    # Define variables
    x = model.addVar(name="A400", lb=0, vtype=gp.GRB.INTEGER)  # Number of A400 keyboards
    y = model.addVar(name="P500", lb=0, vtype=gp.GRB.INTEGER)  # Number of P500 keyboards

    # Objective function: Maximize profit
    model.setObjective(35 * x + 80 * y, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x + 9 * y <= 45, name="labour_hours")  # Labour hours constraint
    model.addConstr(x >= 3 * y, name="demand_forecast")  # Demand forecast constraint

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal production levels: A400 = {x.varValue}, P500 = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

if __name__ == "__main__":
    solve_production_problem()
