
import gurobipy as gp

# Create a new model
model = gp.Model("Pill Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Pill_A")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Pill_B")

# Set objective function
model.setObjective(3*x + 5*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x + 5*y >= 30, "Muscle_Relaxant")
model.addConstr(3*x + y >= 15, "Anxiety_Medication")
model.addConstr(4*x + 3*y >= 20, "Pain_Reliever")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Pill A: {x.x}")
    print(f"Number of Pill B: {y.x}")
    print(f"Total Cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

