
from gurobipy import *

# Create a new model
m = Model("Pill_Purchase")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Pill_A", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="Pill_B", lb=0)

# Set the objective function
m.setObjective(3*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 5*y >= 30, "Muscle_Relaxant")
m.addConstr(3*x + y >= 15, "Anxiety_Medication")
m.addConstr(4*x + 3*y >= 20, "Pain_Reliever")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pill A: {x.x}")
    print(f"Pill B: {y.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
