
import gurobi

def solve_pill_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="pill_A", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of pills A
    y = model.addVar(name="pill_B", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of pills B

    # Objective function: Minimize cost
    model.setObjective(3*x + 5*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2*x + 5*y >= 30, name="muscle_relaxant")  # Muscle relaxant constraint
    model.addConstr(3*x + y >= 15, name="anxiety_medication")  # Anxiety medication constraint
    model.addConstr(4*x + 3*y >= 20, name="pain_reliever")  # Pain reliever constraint

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Number of pills A: {x.varValue}")
        print(f"Number of pills B: {y.varValue}")
    else:
        print("The model is infeasible")

solve_pill_problem()
