
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("glass_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="sliding_doors")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="windows")

# Set objective function
m.setObjective(30*x + 25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 120, "min_sliding_doors")
m.addConstr(y >= 110, "min_windows")
m.addConstr(x <= 210, "max_sliding_doors")
m.addConstr(y <= 170, "max_windows")
m.addConstr(x + y >= 250, "total_products")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal sliding doors: {x.x}")
    print(f"Optimal windows: {y.x}")
    print(f"Optimal profit: {m.objVal}")
else:
    print("Infeasible or unbounded")

