
from gurobipy import *

# Create a new model
m = Model("Glass_Company_Profit_Optimization")

# Decision variables
x = m.addVar(lb=120, ub=210, vtype=GRB.CONTINUOUS, name="sliding_doors")
y = m.addVar(lb=110, ub=170, vtype=GRB.CONTINUOUS, name="windows")

# Objective function: Maximize profit
m.setObjective(30*x + 25*y, GRB.MAXIMIZE)

# Constraint: Ship at least 250 products per day
m.addConstr(x + y >= 250, "total_products")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Produce {x.x} sliding doors and {y.x} windows.")
else:
    print("No optimal solution found.")

