
import gurobi

def solve_glass_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(lb=120, ub=210, name="Sliding_Doors")
    W = model.addVar(lb=110, ub=170, name="Windows")

    # Objective function: Maximize profit
    model.setObjective(30*D + 25*W, gurobi.GRB.MAXIMIZE)

    # Constraint: At least 250 products per day
    model.addConstr(D + W >= 250, name="Total_Products")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Sliding Doors: {D.varValue}")
        print(f"Windows: {W.varValue}")
        print(f"Max Profit: ${30*D.varValue + 25*W.varValue}")
    else:
        print("No optimal solution found.")

# Run the function
solve_glass_company_problem()
