
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create decision variables
x = m.addVar(lb=0, name="spinach_acres")
y = m.addVar(lb=0, name="kale_acres")

# Set objective function
m.setObjective(20*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "land_constraint")
m.addConstr(40*x + 50*y <= 14000, "seed_budget_constraint")
m.addConstr(x + 2*y <= 450, "maintenance_time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of spinach")
    print(f"Plant {y.x} acres of kale")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

