
from gurobipy import *

# Create a new model
m = Model("Linda_Farming")

# Define the decision variables
x = m.addVar(lb=0, name="spinach_acres")
y = m.addVar(lb=0, name="kale_acres")

# Objective function: Maximize profit
m.setObjective(20*x + 30*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 300, name="land_constraint")
m.addConstr(40*x + 50*y <= 14000, name="budget_constraint")
m.addConstr(x + 2*y <= 450, name="maintenance_time_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Spinach acres: {x.x}")
    print(f"Kale acres: {y.x}")
    print(f"Max Profit: ${20*x.x + 30*y.x:.2f}")
else:
    print("No optimal solution found.")
