
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(lb=0, name="Spinach_Acres")
    K = model.addVar(lb=0, name="Kale_Acres")

    # Objective function: Maximize profit
    model.setObjective(20*S + 30*K, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(S + K <= 300, name="Land_Constraint")

    # Budget constraint
    model.addConstr(40*S + 50*K <= 14000, name="Budget_Constraint")

    # Maintenance hours constraint
    model.addConstr(S + 2*K <= 450, name="Maintenance_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of Spinach: {S.varValue}")
        print(f"Optimal acres of Kale: {K.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
