
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("amusement_park")

    # Create variables
    r = model.addVar(vtype=GRB.INTEGER, name="r") # regular tickets
    p = model.addVar(vtype=GRB.INTEGER, name="p") # premium tickets

    # Set objective function
    model.setObjective(50*r + 100*p, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(r + p <= 1000, "total_tickets")
    model.addConstr(p >= 100, "min_premium")
    model.addConstr(r >= 5*p, "regular_preference")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal}")
        print(f"Regular tickets: {r.x}")
        print(f"Premium tickets: {p.x}")
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
