
from gurobipy import *

# Create a model
m = Model("Amusement_Park_Ticket_Sales")

# Define variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Tickets")
P = m.addVar(vtype=GRB.CONTINUOUS, name="Premium_Tickets")

# Objective function: Maximize profit
m.setObjective(50*R + 100*P, GRB.MAXIMIZE)

# Constraints
m.addConstr(R + P <= 1000, "Total_Tickets_Constraint")
m.addConstr(P >= 100, "Minimum_Premium_Tickets_Constraint")
m.addConstr(R >= 5*P, "Regular_vs_Premium_Tickets_Constraint")
m.addConstr(R >= 0, "Non_Negativity-Regular")
m.addConstr(P >= 0, "Non_Negativity-Premium")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Tickets: {R.x}")
    print(f"Premium Tickets: {P.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
