
import gurobi

def solve_amusement_park_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Regular_Tickets")
    P = model.addVar(lb=0, name="Premium_Tickets")

    # Objective function: Maximize profit
    model.setObjective(50*R + 100*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R + P <= 1000, name="Total_Tickets")
    model.addConstr(P >= 100, name="Premium_Tickets_Min")
    model.addConstr(R >= 5*P, name="Regular_to_Premium_Ratio")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Regular Tickets: {R.varValue}")
        print(f"Premium Tickets: {P.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_amusement_park_problem()
