
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("NecklaceProduction")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="diamond_necklaces")  # allow fractional necklaces for now
y = model.addVar(vtype=GRB.CONTINUOUS, name="gold_necklaces")

# Set the objective function
model.setObjective(1500 * x + 500 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 5 * y <= 30, "design_constraint")
model.addConstr(10 * x + 2 * y <= 45, "crafting_constraint")
model.addConstr(x >= 0, "x_nonneg")
model.addConstr(y >= 0, "y_nonneg")


# Optimize the model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print the optimal solution
    print(f"Optimal Solution:")
    print(f"  Diamond Necklaces: {x.x}")
    print(f"  Gold Necklaces: {y.x}")
    print(f"  Optimal Profit: ${model.objVal}")

    # Round down to get integer solutions if needed
    print("\nInteger Solution (rounded down):")
    print(f"  Diamond Necklaces: {int(x.x)}")
    print(f"  Gold Necklaces: {int(y.x)}")
    print(f"  Profit (rounded down solution): ${1500*int(x.x) + 500*int(y.x)}")

