
from gurobipy import *

# Create a new model
m = Model("Jewelry_Shop")

# Define the decision variables
D = m.addVar(vtype=GRB.INTEGER, name="Diamond_Necklaces")
G = m.addVar(vtype=GRB.INTEGER, name="Gold_Necklaces")

# Set the objective function to maximize profit
m.setObjective(1500*D + 500*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*D + 5*G <= 30, "Designing_Constraint")
m.addConstr(10*D + 2*G <= 45, "Crafting_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Diamond Necklaces: {D.x}")
    print(f"Number of Gold Necklaces: {G.x}")
    print(f"Maximum Profit: ${1500*D.x + 500*G.x}")
else:
    print("No optimal solution found.")
