
import gurobi as gp

# Create a new model
model = gp.Model("jewelry_shop")

# Define the decision variables
D = model.addVar(lb=0, name="diamond_necklaces", vtype=gp.GRB.INTEGER)
G = model.addVar(lb=0, name="gold_necklaces", vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(1500*D + 500*G, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*D + 5*G <= 30, name="designing_time")
model.addConstr(10*D + 2*G <= 45, name="crafting_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution:")
    print(f"Diamond Necklaces: {D.varValue}")
    print(f"Gold Necklaces: {G.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no optimal solution.")
