
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Eric's Combo Optimization")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="x") # Number of Combo X
y = model.addVar(vtype=GRB.INTEGER, name="y") # Number of Combo Y

# Set objective function
model.setObjective(12*x + 15*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + y <= 25, "Wireless Keyboards")
model.addConstr(3*y <= 13, "Wired Earbuds")
model.addConstr(2*x + y <= 19, "USB Hubs")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Combo X: {x.x}")
    print(f"Number of Combo Y: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

