
from gurobipy import *

# Create a new model
m = Model("Eric's Combo Problem")

# Define the decision variables
x = m.addVar(name='Combo_X', vtype=GRB.INTEGER, lb=0)
y = m.addVar(name='Combo_Y', vtype=GRB.INTEGER, lb=0)

# Set the objective function to maximize profit
m.setObjective(12*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + y <= 25, name='Wireless_Keyboards')
m.addConstr(3*y <= 13, name='Wired_Earbuds')
m.addConstr(2*x + y <= 19, name='USB_Hubs')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: Combo X = {x.x}, Combo Y = {y.x}")
    print(f"Total Profit: ${12*x.x + 15*y.x}")
else:
    print("No optimal solution found")
