
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="Combo_X")
    y = model.addVar(lb=0, name="Combo_Y")

    # Objective function: Maximize profit
    model.setObjective(12*x + 15*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x + y <= 25, name="Wireless_Keyboard_Constraint")
    model.addConstr(3*y <= 13, name="Wired_Earbuds_Constraint")
    model.addConstr(2*x + y <= 19, name="USB_Hubs_Constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_problem()
