
import gurobipy as gp

# Create a new model
m = gp.Model("BobsCoffeeShop")

# Create variables
c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="coffee") # Cups of coffee
t = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tea")    # Cups of tea

# Set objective function
m.setObjective(1*c + 2*t, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*c + 3*t <= 500, "time_constraint")
m.addConstr(c + t <= 300, "total_cups_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of coffee cups: {c.x}")
    print(f"Number of tea cups: {t.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

