
from gurobipy import *

# Create a new model
m = Model("Coffee_Tea_Problem")

# Define variables
C = m.addVar(name="Cups_of_Coffee", vtype=GRB.CONTINUOUS, lb=0)
T = m.addVar(name="Cups_of_Tea", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1*C + 2*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*C + 3*T <= 500, name="Time_Constraint")
m.addConstr(C + T <= 300, name="Product_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cups of Coffee: {C.x}")
    print(f"Cups of Tea: {T.x}")
    print(f"Total Profit: ${1*C.x + 2*T.x:.2f}")
else:
    print("No optimal solution found")
