
import gurobi

def solve_coffee_tea_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    C = model.addVar(lb=0, name="Coffee")
    T = model.addVar(lb=0, name="Tea")

    # Objective function: Maximize 1*C + 2*T
    model.setObjective(C + 2*T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*C + 3*T <= 500, name="Time_Constraint")
    model.addConstr(C + T <= 300, name="Product_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cups of Coffee: {C.varValue}")
        print(f"Cups of Tea: {T.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_coffee_tea_problem()
