
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("dog_food")

# Create variables
x = m.addVar(lb=0, name="x") # Bags of A
y = m.addVar(lb=0, name="y") # Bags of B

# Set objective function
m.setObjective(3.5 * x + 2.5 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x + 4 * y >= 30, "protein_constraint")
m.addConstr(4 * x + 2 * y >= 35, "calcium_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Bags of A: {x.x:.2f}")
    print(f"Bags of B: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

