
from gurobipy import *

# Create a new model
m = Model("Pet_Food_Mixture")

# Define the decision variables
x_A = m.addVar(name="bags_of_type_A", lb=0)
x_B = m.addVar(name="bags_of_type_B", lb=0)

# Set the objective function to minimize the total cost
m.setObjective(3.50*x_A + 2.50*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x_A + 4*x_B >= 30, name="protein_constraint")
m.addConstr(4*x_A + 2*x_B >= 35, name="calcium_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x_A.varName} = {x_A.x}, {x_B.varName} = {x_B.x}")
    print(f"Total cost: ${3.50*x_A.x + 2.50*x_B.x:.2f}")
else:
    print("No optimal solution found")
